<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\ActivityModel;
use App\Models\EducationModel;
use App\Models\CertificateModel;

class HomeController extends BaseController
{
    protected $biodataModel;
    protected $activityModel;
    protected $educationModel;
    protected $certificateModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->activityModel = new ActivityModel();
        $this->educationModel = new EducationModel();
        $this->certificateModel = new CertificateModel();
    }

    public function index()
    {
        $biodata = $this->biodataModel->getBiodata();
        $recentActivities = $this->activityModel->orderBy('tanggal', 'DESC')->limit(3)->findAll();
        $recentCertificates = $this->certificateModel->orderBy('tanggal_terbit', 'DESC')->limit(3)->findAll();
        $certificates = $this->certificateModel->orderBy('tanggal_terbit', 'DESC')->limit(6)->findAll();

        $data = [
            'title' => 'Home - Portfolio',
            'biodata' => $biodata,
            'recentActivities' => $recentActivities,
            'recentCertificates' => $recentCertificates,
            'certificates' => $certificates
        ];

        return view('home/index', $data);
    }
}

